/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import dev.toma.gunsrpg.client.render.infobar.QuestDisplayDataModel;
import dev.toma.gunsrpg.common.quests.QuestProperties;
import dev.toma.gunsrpg.common.quests.quest.IAdditionalClientInfo;
import dev.toma.gunsrpg.common.quests.quest.IQuestFactory;
import dev.toma.gunsrpg.common.quests.quest.ItemHandoverData;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestDeserializationContext;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.quests.trigger.Trigger;
import dev.toma.gunsrpg.common.quests.trigger.TriggerResponseStatus;
import dev.toma.gunsrpg.util.properties.IPropertyReader;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemHandoverQuest
extends Quest<ItemHandoverData>
implements IAdditionalClientInfo {
    public static final String DELIVER = "quest.deliver";
    private static final ITextComponent[] NOTES = new ITextComponent[]{new TranslationTextComponent("quest.deliver.info").func_240699_a_(TextFormatting.ITALIC)};
    public static final IQuestFactory<ItemHandoverData, ItemHandoverQuest> FACTORY = IQuestFactory.of(ItemHandoverQuest::new, ItemHandoverQuest::new);
    private final Object2IntMap<Item> dataMap = new Object2IntAVLTreeMap(this::compareItems);

    public ItemHandoverQuest(QuestScheme<ItemHandoverData> scheme, UUID traderId) {
        super(scheme, traderId);
        this.initializeData();
    }

    public ItemHandoverQuest(QuestDeserializationContext<ItemHandoverData> context) {
        super(context);
    }

    @Override
    public void registerTriggers(Quest.ITriggerRegistration registration) {
        registration.addEntry(Trigger.ITEM_HANDOVER, this::tryItemHandover, this::handleSuccessfulHandover);
    }

    @Override
    public ITextComponent[] getAdditionalNotes() {
        return NOTES;
    }

    @Override
    protected void fillDataModel(QuestDisplayDataModel model) {
        model.addQuestHeader(this, false);
        this.dataMap.forEach((item, remainder) -> model.addInformationRow((ITextComponent)new TranslationTextComponent(DELIVER, new Object[]{item.func_200295_i(ItemStack.field_190927_a)}), this, q -> new StringTextComponent(remainder + "x")));
        model.addConditionDisplay(this);
    }

    @Override
    protected void writeQuestData(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        this.dataMap.forEach((item, remainder) -> {
            CompoundNBT itemNbt = new CompoundNBT();
            itemNbt.func_74778_a("item", item.getRegistryName().toString());
            itemNbt.func_74768_a("remainder", remainder.intValue());
            list.add((Object)itemNbt);
        });
        nbt.func_218657_a("items", (INBT)list);
    }

    @Override
    protected void readQuestData(CompoundNBT nbt) {
        this.dataMap.clear();
        ListNBT list = nbt.func_150295_c("items", 10);
        list.forEach(inbt -> {
            CompoundNBT itemNbt = (CompoundNBT)inbt;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemNbt.func_74779_i("item")));
            int remainder = itemNbt.func_74762_e("remainder");
            this.dataMap.put((Object)item, remainder);
        });
    }

    private TriggerResponseStatus tryItemHandover(Trigger trigger, IPropertyReader reader) {
        ItemStack itemStack = reader.getProperty(QuestProperties.USED_ITEM);
        UUID uuid = reader.getProperty(QuestProperties.UUID);
        UUID questId = this.getOriginalAssignerId();
        if (itemStack.func_190926_b()) {
            return TriggerResponseStatus.PASS;
        }
        Item item = itemStack.func_77973_b();
        if (!this.dataMap.containsKey((Object)item)) {
            return TriggerResponseStatus.PASS;
        }
        int remainder = this.dataMap.getInt((Object)item);
        if (questId.equals(uuid) || questId.equals(Util.field_240973_b_)) {
            return remainder > 0 ? TriggerResponseStatus.OK : TriggerResponseStatus.PASS;
        }
        return TriggerResponseStatus.PASS;
    }

    private void handleSuccessfulHandover(Trigger trigger, IPropertyReader reader) {
        ItemStack itemStack = reader.getProperty(QuestProperties.USED_ITEM);
        if (itemStack.func_190926_b()) {
            return;
        }
        Item item = itemStack.func_77973_b();
        int count = itemStack.func_190916_E();
        int remainder = this.dataMap.getInt((Object)item);
        int taken = Math.min(count, remainder);
        itemStack.func_190918_g(taken);
        int result = remainder - taken;
        if (result <= 0) {
            this.dataMap.removeInt((Object)item);
        } else {
            this.dataMap.put((Object)item, result);
        }
        if (this.dataMap.isEmpty()) {
            this.setStatus(QuestStatus.COMPLETED);
        }
        this.trySyncClient();
    }

    private void initializeData() {
        ItemStack[] itemStacks;
        ItemHandoverData data = (ItemHandoverData)this.getActiveData();
        for (ItemStack stack : itemStacks = data.getItems()) {
            this.dataMap.put((Object)stack.func_77973_b(), stack.func_190916_E());
        }
    }

    private int compareItems(Item item1, Item item2) {
        return item1.getRegistryName().compareTo(item2.getRegistryName());
    }
}

